/*
THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES INC. ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE
DISCLAIMED. IN NO EVENT SHALL ANALOG DEVICES INC. BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

YOU ASSUME ANY AND ALL RISK FROM THE USE OF THIS CODE OR SUPPORT FILE.

IT IS THE RESPONSIBILITY OF THE PERSON INTEGRATING THIS CODE INTO AN APPLICATION
TO ENSURE THAT THE RESULTING APPLICATION PERFORMS AS REQUIRED AND IS SAFE.

    Module       : main.c
    Description  : main
    Date         : 22nd June 2010
    Version      : v1.02
    Changelog    : v1.02 Use updated menu system contained in menu.c
    Changelog    : v1.01 Update the BBRAM if needed before dumping it.
                         printf inputted values when changing settings
    Changelog    : v1.00 Initial
*/

#include <include.h>

extern boolean       bPacketRcv;
boolean              bCfgChanged    = FALSE; 
U8                   ucXMitData[PKT_MAX_PAYLOAD_LEN];

boolean DoBackgroundTasks(void);

// Main Menu Functions
/*************************************************************************/
/* void DoMainMenuTxCarrier     (void)                                   */
/*       Transmit a carrier                                              */
/*************************************************************************/
void DoMainMenuTxCarrier     (void)
{
   boolean              bOk            = TRUE; 
   printf("Carrier\n");
   if (bCfgChanged)
      {
      // Update the radio configuration if needed
      printf("Updating Radio Config\n");
      bOk   = bOk && ADF_ConfigureRadio(NULL);
      bCfgChanged = FALSE;
      }
   bOk   = bOk && ADF_TransmitCarrier();
}
/*************************************************************************/
/* void DoMainMenuRcvPacket     (void)                                   */
/*                                                                       */
/*************************************************************************/
void DoMainMenuRcvPacket     (void)
{
   boolean              bOk            = TRUE; 
   printf("Receive Packet\n");
   if (bCfgChanged)
      {
      // Update the radio configuration if needed
      printf("Updating Radio Config\n");
      bOk   = bOk && ADF_ConfigureRadio(NULL);
      bCfgChanged = FALSE;
      }
   bOk   = bOk && ADF_ReceivePacket();
}
/*************************************************************************/
/* void DoMainMenuXMitPacket    (void)                                   */
/*                                                                       */
/*************************************************************************/
void DoMainMenuXMitPacket    (void)
{
   boolean              bOk            = TRUE; 
   printf("Transmit Packet\n");
   if (bCfgChanged)
      {
      // Update the radio configuration if needed
      printf("Updating Radio Config\n");
      bOk   = bOk && ADF_ConfigureRadio(NULL);
      bCfgChanged = FALSE;
      }
   bOk   = bOk && ADF_TransmitPacket(ucXMitData,(U8)strlen((const char *)ucXMitData) + 0x1);
}
/*************************************************************************/
/* void DoMainMenuXMitPreamble  (void)                                   */
/*                                                                       */
/*************************************************************************/
void DoMainMenuXMitPreamble  (void)
{
   boolean              bOk            = TRUE; 
   printf("Transmit Preamble\n");
   if (bCfgChanged)
      {
      // Update the radio configuration if needed
      printf("Updating Radio Config\n");
      bOk   = bOk && ADF_ConfigureRadio(NULL);
      bCfgChanged = FALSE;
      }
   bOk   = bOk && ADF_TransmitPreamble();
}
/*************************************************************************/
/* void DoMainMenuPrintfBBRAM   (void)                                   */
/*                                                                       */
/*************************************************************************/
void DoMainMenuPrintfBBRAM   (void)
{
   boolean              bOk            = TRUE; 
   if (bCfgChanged)
      {
      // Update the radio configuration if needed
      printf("Updating Radio Config\n");
      bOk   = bOk && ADF_ConfigureRadio(NULL);
      bCfgChanged = FALSE;
      }
  bOk   = bOk && ADF_BBRAMReadBack();
  ADF_PrintBBRAM(NULL);
}
/*************************************************************************/
/* void DoMainMenuSetTXData     (void)                                   */
/*                                                                       */
/*************************************************************************/
void DoMainMenuSetTXData     (void)
{
   printf("Enter Xmit String (%d char max > ",PKT_MAX_PAYLOAD_LEN);
   (void)scanf ("%s",ucXMitData);
}
/*************************************************************************/
/* void DoMainMenuSetDataRate   (void)                                   */
/*                                                                       */
/*************************************************************************/
void DoMainMenuSetDataRate   (void)
{
   unsigned long        ulValue;
   printf("Enter data rate (bps/dec) > ");
   if(scanf ("%ld",&ulValue) == 1)
      {
      printf("\nSetting data rate to %ld\n",ulValue);
      ADF_SetDataRate         (NULL,ulValue);
      bCfgChanged = TRUE;
      }
   else
      printf("ERROR!");
}
/*************************************************************************/
/* void DoMainMenuSetCentreFreq (void)                                   */
/*                                                                       */
/*************************************************************************/
void DoMainMenuSetCentreFreq (void)
{
   unsigned long        ulValue;
   printf("Enter Centre Frequency (Hz/dec) > ");
   if(scanf ("%ld",&ulValue) == 1)
      {
      printf("\nSetting Centre Frequency to %ld\n",ulValue);
      ADF_SetChannelFreq         (NULL,ulValue);
      bCfgChanged = TRUE;
      }
   else
      printf("ERROR!");
}
/*************************************************************************/
/* void DoMainMenuSetFreqDev    (void)                                   */
/*                                                                       */
/*************************************************************************/
void DoMainMenuSetFreqDev    (void)
{
   unsigned long        ulValue;
   printf("Enter Frequency Deviation (Hz/dec) > ");
   if(scanf ("%ld",&ulValue) == 1)
      {
      printf("\nSetting Frequency Deviation to %ld\n",ulValue);
      ADF_SetFreqDev(NULL,ulValue);
      bCfgChanged = TRUE;
      }
   else
      printf("ERROR!");
}

/*************************************************************************/
/* void DoMainMenuSetPALevel    (void)                                   */
/*                                                                       */
/*************************************************************************/
void DoMainMenuSetPALevel    (void)
{
   unsigned long        ulValue;
   printf("Enter PA Level (0-15/dec) > ");
   if(scanf ("%ld",&ulValue) == 1)
      {
      printf("\nSetting PA Level to %ld\n",ulValue);
      ADF_SetPALevel(NULL,ulValue);
      bCfgChanged = TRUE;
      }
   else
      printf("ERROR!");
}

/*************************************************************************/
/* void DoMainMenuSetDiscrimBW    (void)                                   */
/*                                                                       */
/*************************************************************************/
void DoMainMenuSetDiscrimBW    (void)
{
   unsigned long        ulValue;
   printf("Enter Discrim BW (hex) > 0x");
   if(scanf ("%lX",&ulValue) == 1)
      {
      printf("\nSetting Discrim BW to 0x%lX\n",ulValue);
      ADF_SetDiscrimBW(NULL,ulValue);
      bCfgChanged = TRUE;
      }
   else
      printf("ERROR!");
}

/*************************************************************************/
/* void DoMainMenuSetDiscrimPhase    (void)                                   */
/*                                                                       */
/*************************************************************************/
void DoMainMenuSetDiscrimPhase    (void)
{
   unsigned long        ulValue;
   printf("Enter Discrim Phase (hex) > 0x");
   if(scanf ("%lX",&ulValue) == 1)
      {
      printf("\nSetting Discrim Phase to 0x%lX\n",ulValue);
      ADF_SetDiscrimPhase(NULL,ulValue);
      bCfgChanged = TRUE;
      }
   else
      printf("ERROR!");
}


TyMenuItem RadioParametersMenuItems[] = 
{
   {"Printf BBRAM"             ,        DoMainMenuPrintfBBRAM  },
   {"Set Data"                 ,        DoMainMenuSetTXData    },
   {"Set Data Rate"            ,        DoMainMenuSetDataRate  },
   {"Set Centre Frequency"     ,        DoMainMenuSetCentreFreq},
   {"Set Frequency Deviation"  ,        DoMainMenuSetFreqDev   },
   {"Set PA Level"             ,        DoMainMenuSetPALevel   },
   {"Set Discriminator BW"     ,        DoMainMenuSetDiscrimBW },
   {"Set Discriminator Phase"  ,        DoMainMenuSetDiscrimPhase },
   {NULL                       ,        NULL                   }
}; 

/*************************************************************************/
/* void DoMainMenuRadioParameters    (void)                              */
/*                                                                       */
/*************************************************************************/
void DoMainMenuRadioParameters(void)
{
   DoMenu("Radio Parameters Menu", RadioParametersMenuItems,FALSE,DoBackgroundTasks);
}


TyMenuItem MainMenuItems[] = 
{
   {"Tx Carrier"               ,        DoMainMenuTxCarrier      },
   {"Receive Packet"           ,        DoMainMenuRcvPacket      },
   {"Transmit Packet"          ,        DoMainMenuXMitPacket     },
   {"Tx Preamble"              ,        DoMainMenuXMitPreamble   },
   {"Printf BBRAM"             ,        DoMainMenuPrintfBBRAM    },
   {"Radio Parameters"         ,        DoMainMenuRadioParameters},
   {NULL                       ,        NULL                     }
}; 


/*************************************************************************/
/* boolean DoBackgroundTasks(void)                                       */
/*         Perform some background tasks while waiting at a prompt       */
/*************************************************************************/
boolean DoBackgroundTasks(void)
{
   boolean bOP = FALSE;

   if (bPacketRcv)
       {
       unsigned char ucData[PKT_MAX_PKT_LEN];
       int i;
       boolean bOk = TRUE;

       // Variable length data. First byte is length

       // Read header
       bOk   = bOk && ADF_MMapRead(PKT_RAM_BASE_PTR, PKT_HDR_LEN, ucData);

       // Read payload
       if (ucData[0] > PKT_HDR_LEN)
           {
           bOk   = bOk && ADF_MMapRead(PKT_RAM_BASE_PTR + PKT_HDR_LEN, ucData[0] - PKT_HDR_LEN, ucData+ PKT_HDR_LEN);
           }

       printf("\n\nReceived Packet-> ");
       if (bOk)
           {
           for(i=0x0;i<ucData[0];i++)
              printf("0x%02X ",ucData[i]);
           }
       printf("\n%s ",ucData + PKT_HDR_LEN);
       bPacketRcv = FALSE;
       bOP = TRUE;
       }

   return bOP;
}

/******************************************************************************/
/* Function    : main                                                         */
/* Description : main function for ADuCRF101 Prototype Application software    */
/******************************************************************************/
int main(void)
{
   boolean              bOk            = TRUE; 

   BSP_Initialisation();     // Initialise ports, peripherals, etc 
   printf("\n\n\n\n\n\n" );
   printf("EVAL-ADuCRF101EBZ %s %s\n",__TIME__,__DATE__);
   bOk   = bOk && ADF_FirstConnect();                           
   printf("Hit any key to continue ....\n");
   (void)getchar();

   strcpy((char *)ucXMitData,"EVAL-ADuCRF101EBZ");

   while(1)
      {
      DoMenu("Main Menu", MainMenuItems,TRUE,DoBackgroundTasks);
      }
}                                    







